import java.applet.*;
import java.awt.*;

public class Aplet extends Applet {
  String tekst;
  Font font;

  public void init() {
    String fontName = getParameter("fontName");
    if(fontName == null) fontName = "Default";

    String fontStyle = getParameter("fontStyle");
    int fontStyleInt = Font.PLAIN;

    if("bold".equals(fontStyle))
      fontStyleInt = Font.BOLD;
    else if ("italic".equals(fontStyle))
      fontStyleInt = Font.ITALIC;
      

    int fontSizeInt = 10;
    String fontSize = getParameter("fontSize");
    try{
      fontSizeInt = Integer.parseInt(fontSize);
    }
    catch(NumberFormatException e){
    }

    font = new Font(fontName, fontStyleInt, fontSizeInt);

    if((tekst = getParameter("tekst")) == null)
      tekst = "";
  }
  public void paint (Graphics gDC) {
    gDC.setFont(font);
    FontMetrics fm = gDC.getFontMetrics();

    int strWidth = fm.stringWidth(tekst);
    int strHeight = fm.getHeight();

    int x = (getWidth() - strWidth) / 2;
    int y = (getHeight() + strHeight) / 2;

    gDC.clearRect(0, 0, getSize().width, getSize().height);
    gDC.drawString(tekst, x, y);
  }
}
